<?php
require 'config.php';

$conn = getDbConnection();

$query = "SELECT patrols.id, users.real_name AS userName, sites.site_name AS siteName, 
                 patrols.tag_name, patrols.patrol_time 
          FROM patrols 
          JOIN users ON patrols.user_id = users.user_id 
          JOIN sites ON patrols.site_id = sites.site_id 
          ORDER BY patrols.patrol_time DESC";

$result = $conn->query($query);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Patrol Records</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        <h2>Patrol Records</h2>
        <table class="table table-bordered">
            <thead class="table-dark">
                <tr>
                    <th>User</th>
                    <th>Site</th>
                    <th>Tag</th>
                    <th>Time</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= $row['userName'] ?></td>
                    <td><?= $row['siteName'] ?></td>
                    <td><?= $row['tag_name'] ?></td>
                    <td><?= $row['patrol_time'] ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
