<?php
// guardianapi/sms_balance.php
declare(strict_types=1);

header('Content-Type: application/json; charset=UTF-8');

require_once __DIR__ . '/config.php';
$conn = getDbConnection();

if (!isset($GLOBALS['AUTH'])) { http_response_code(401); echo json_encode(['status'=>'error','message'=>'Unauthorized']); exit; }
$auth = $GLOBALS['AUTH'];

// Only admins should see provider balance
if (($auth['role'] ?? '') !== 'admin') { http_response_code(403); echo json_encode(['status'=>'error','message'=>'Forbidden']); exit; }

// Build provider request (no keys leaked to FE)
$payload = [
  'apikey'    => defined('SMS_APIKEY')  ? SMS_APIKEY  : '',
  'partnerID' => defined('SMS_PARTNER') ? SMS_PARTNER : '',
];

$endpoint = (defined('SMS_BASE') ? rtrim(SMS_BASE,'/').'/' : 'https://sms.textsms.co.ke/api/services/') . 'getbalance/';

$ch = curl_init($endpoint);
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_HTTPHEADER     => ['Content-Type: application/json'],
  CURLOPT_POST           => true,
  CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
  CURLOPT_TIMEOUT        => 30,
]);
$respBody = curl_exec($ch);
$err      = curl_error($ch);
curl_close($ch);

if ($err) {
  http_response_code(502);
  echo json_encode(['status'=>'error','message'=>'Provider error','detail'=>$err]); exit;
}

$raw = json_decode($respBody, true) ?: [];
$code = (int)($raw['response-code'] ?? $raw['respose-code'] ?? 0);
$creditStr = (string)($raw['credit'] ?? '');

$balance = null;
if ($code === 200 && $creditStr !== '') {
  // normalise to float
  $balance = (float)preg_replace('/[^\d.]+/','', $creditStr);
}

echo json_encode([
  'status'  => 'success',
  'balance' => $balance,   // <— ONLY what the UI needs
  'currency'=> 'KES',
]);
