<?php
header("Content-Type: application/json");
require_once 'config.php';

$conn = getDbConnection();
$data = json_decode(file_get_contents("php://input"));

// Validate Authorization header
$headers = apache_request_headers();
$authHeader = $headers['Authorization'] ?? null;
if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    http_response_code(401);
    echo json_encode(["status" => "error", "message" => "Unauthorized: Missing or invalid token"]);
    exit();
}

$token = $matches[1];

// Validate admin user
$stmt = $conn->prepare("SELECT id, username FROM admin_users WHERE token = ?");
$stmt->bind_param("s", $token);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
if (!$user) {
    http_response_code(401);
    echo json_encode(["status" => "error", "message" => "Unauthorized: Invalid token"]);
    exit();
}

$admin_id = $user['id'];
$username = $user['username'];

// Validate event type
if (!isset($data->event_type)) {
    http_response_code(400);
    echo json_encode(["status" => "error", "message" => "Missing event type"]);
    exit();
}

$event_type = $data->event_type;

// Insert into database
$stmt = $conn->prepare("INSERT INTO admin_logs (admin_id, username, event_type) VALUES (?, ?, ?)");
$stmt->bind_param("iss", $admin_id, $username, $event_type);

if ($stmt->execute()) {
    echo json_encode(["status" => "success", "message" => "Admin log saved"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to save log"]);
}

$stmt->close();
$conn->close();
?>
