<?php
require __DIR__ . '/config.php';

header('Content-Type: application/json');

$conn = getDbConnection();
$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['user_id'], $data['new_password'])) {
    echo json_encode(["success" => false, "status" => "error", "message" => "Invalid input"]);
    exit();
}

$user_id = intval($data['user_id']);
$new_password = password_hash($data['new_password'], PASSWORD_BCRYPT);

$stmt = $conn->prepare("UPDATE users SET password = ? WHERE user_id = ?");
if (!$stmt) {
    echo json_encode(["success" => false, "status" => "error", "message" => "Database error: " . $conn->error]);
    exit();
}

$stmt->bind_param("si", $new_password, $user_id);
if ($stmt->execute()) {
    echo json_encode(["success" => true, "status" => "success", "message" => "Password updated successfully"]);
} else {
    echo json_encode(["success" => false, "status" => "error", "message" => "Failed to update password"]);
}

$stmt->close();
$conn->close();
?>
