<?php
require 'config.php';
header("Content-Type: application/json");

$conn = getDbConnection();

// ✅ Read JSON Input
$data = json_decode(file_get_contents("php://input"), true);
$siteIds = $data['site_ids'] ?? [];

if (empty($siteIds)) {
    echo json_encode(["success" => false, "message" => "No site IDs provided"]);
    exit();
}

// ✅ Prepare Query
$placeholders = implode(',', array_fill(0, count($siteIds), '?'));
$query = "SELECT site_id, site_name FROM sites WHERE site_id IN ($placeholders)";

$stmt = $conn->prepare($query);
$stmt->bind_param(str_repeat("i", count($siteIds)), ...$siteIds);
$stmt->execute();
$result = $stmt->get_result();

// ✅ Fetch Site Names
$sites = [];
while ($row = $result->fetch_assoc()) {
    $sites[] = [
        "site_id" => $row["site_id"],
        "site_name" => $row["site_name"]
    ];
}

// ✅ Return Data
echo json_encode(["success" => true, "sites" => $sites]);

$stmt->close();
$conn->close();
?>
