<?php
require 'db_config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $data = json_decode(file_get_contents("php://input"), true);
    
    if (isset($data['site_id'], $data['name'], $data['type'], $data['latitude'], $data['longitude'])) {
        $site_id = $data['site_id'];
        $name = $data['name'];
        $type = $data['type'];
        $latitude = $data['latitude'];
        $longitude = $data['longitude'];

        $stmt = $conn->prepare("INSERT INTO tags (site_id, name, type, latitude, longitude) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("issdd", $site_id, $name, $type, $latitude, $longitude);

        if ($stmt->execute()) {
            echo json_encode(["success" => true, "message" => "Tag added successfully"]);
        } else {
            echo json_encode(["success" => false, "message" => "Failed to add tag"]);
        }
        $stmt->close();
    } else {
        echo json_encode(["success" => false, "message" => "Invalid input"]);
    }
}
$conn->close();
?>

