<?php
require 'config.php';

$conn = getDbConnection();

$query = "SELECT hourly_checks.id, users.real_name AS userName, sites.site_name AS siteName, 
                 hourly_checks.personal_safety, hourly_checks.site_secure, hourly_checks.equipment_functional, 
                 hourly_checks.comments, hourly_checks.timestamp 
          FROM hourly_checks 
          JOIN users ON hourly_checks.user_id = users.user_id 
          JOIN sites ON hourly_checks.site_id = sites.site_id 
          ORDER BY hourly_checks.timestamp DESC";

$result = $conn->query($query);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Hourly Check Records</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        <h2>Hourly Check Records</h2>
        <table class="table table-bordered">
            <thead class="table-dark">
                <tr>
                    <th>User</th>
                    <th>Site</th>
                    <th>Personal Safety</th>
                    <th>Site Secure</th>
                    <th>Equipment Functional</th>
                    <th>Comments</th>
                    <th>Time</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= $row['userName'] ?></td>
                    <td><?= $row['siteName'] ?></td>
                    <td><?= $row['personal_safety'] ? 'Yes' : 'No' ?></td>
                    <td><?= $row['site_secure'] ? 'Yes' : 'No' ?></td>
                    <td><?= $row['equipment_functional'] ? 'Yes' : 'No' ?></td>
                    <td><?= $row['comments'] ?: 'N/A' ?></td>
                    <td><?= $row['timestamp'] ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
