<?php
require 'config.php'; 
header("Content-Type: application/json");

$conn = getDbConnection();

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', 'book_off_error.log');

$user_id = isset($_GET['user_id']) ? intval($_GET['user_id']) : null;
$date = isset($_GET['date']) ? $_GET['date'] : null;

if (!$user_id || !$date) {
    echo json_encode(["success" => false, "message" => "Missing required parameters"]);
    exit();
}

$query = "SELECT u.real_name, s.site_name, c.clock_out_time 
          FROM clock_out c 
          JOIN users u ON c.user_id = u.user_id 
          JOIN sites s ON c.site_id = s.site_id 
          WHERE c.user_id = ? AND DATE(c.clock_out_time) = ? 
          ORDER BY c.clock_out_time DESC";

$stmt = $conn->prepare($query);
$stmt->bind_param("is", $user_id, $date);
$stmt->execute();
$result = $stmt->get_result();

$records = [];
while ($row = $result->fetch_assoc()) {
    $records[] = $row;
}

echo json_encode(["success" => true, "records" => $records]);
$conn->close();
?>
