<?php
require 'config.php'; // Include database connection

header("Content-Type: application/json");

$conn = getDbConnection();

// Query to fetch site details including latitude and longitude
$query = "SELECT site_id, site_name, site_location, latitude, longitude FROM sites";
$result = $conn->query($query);

if ($result->num_rows > 0) {
    $sites = [];
    while ($row = $result->fetch_assoc()) {
        $sites[] = [
            "id" => $row["site_id"],
            "name" => $row["site_name"],
            "location" => $row["site_location"],
            "latitude" => $row["latitude"],
            "longitude" => $row["longitude"],
        ];
    }

    // Return sites as JSON
    echo json_encode([
        "success" => true,
        "sites" => $sites
    ]);
} else {
    echo json_encode([
        "success" => false,
        "message" => "No sites found"
    ]);
}

$conn->close();
?>

