<?php
// guardianapi/configguardian.php

// 0) Timezone (avoid PHP warnings)
date_default_timezone_set('Africa/Nairobi');

// 1) Database configuration for Guardian Assist
define('GA_DB_CONNECTION', 'mysql');
define('GA_DB_SERVER',     'localhost');
define('GA_DB_USERNAME',   'asbdpijm_shemking');      // same credentials as Guardian DB
define('GA_DB_PASSWORD',   'Shemking@18');
define('GA_DB_PORT',       '3306');
define('GA_DB_NAME',       'asbdpijm_guardianprod');

// 2) SMS provider (optional — kept consistent for future use)
define('GA_SMS_PROVIDER', 'textsms');
define('GA_SMS_BASE', 'https://sms.textsms.co.ke/api/services/');
define('GA_SMS_APIKEY', '41c2aa6e25d87f2e0e26d2a147d21ce5');
define('GA_SMS_PARTNER', '14186');
define('GA_SMS_SHORTCODE', 'Signal VMS');

// 3) Legacy mysqli connection for existing Guardian Assist scripts.
//    - Throws exceptions on error.
//    - Enforces UTF-8.
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

function getGuardianDbConnection(): mysqli {
    $conn = new mysqli(GA_DB_SERVER, GA_DB_USERNAME, GA_DB_PASSWORD, GA_DB_NAME, GA_DB_PORT);
    $conn->set_charset('utf8mb4');
    return $conn;
}

// 4) New PDO connection for JSON-API scripts.
//    - Persistent connections.
//    - 5-second timeout to avoid long hangs.
//    - UTF-8 charset.
//    - Exceptions on errors.
function getGuardianPdoConnection(): PDO {
    $dsn = sprintf(
        '%s:host=%s;port=%s;dbname=%s;charset=utf8mb4',
        GA_DB_CONNECTION,
        GA_DB_SERVER,
        GA_DB_PORT,
        GA_DB_NAME
    );

    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
        PDO::ATTR_PERSISTENT         => true,
        PDO::ATTR_TIMEOUT            => 5,          // seconds
    ];

    try {
        return new PDO($dsn, GA_DB_USERNAME, GA_DB_PASSWORD, $options);
    } catch (PDOException $e) {
        // Log the real error for debugging
        error_log('Guardian PDO connection failed: ' . $e->getMessage());

        // Send a generic JSON error if headers aren’t sent yet
        if (!headers_sent()) {
            http_response_code(500);
            header('Content-Type: application/json; charset=utf-8');
        }
        echo json_encode([
            'success' => false,
            'message' => 'Internal server error'
        ]);
        exit;
    }
}
