<?php
// config2.php
// Central DB config + BOTH mysqli and PDO helpers (PDO is preferred)

define('DB_CONNECTION', 'mysql');
define('DB_SERVER', 'localhost');
define('DB_USERNAME', 'asbdpijm_shemking');
define('DB_PASSWORD', 'Shemking@18');
define('DB_PORT', '3306');
define('DB_NAME', 'asbdpijm_guardianprod');

// Optional: allow a read-only “open admin” key for GET endpoints (only if you need it).
// define('OPEN_ADMIN_KEY', 'put-a-long-random-secret-here');

/**
 * Legacy mysqli connector (kept for compatibility)
 */
function getDbConnection() {
    $conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME, (int)DB_PORT);
    if ($conn->connect_error) {
        // Fail hard so upstream can return 500 JSON
        die("Connection failed: " . $conn->connect_error);
    }
    // You CAN set charset if needed
    @$conn->set_charset('utf8mb4');
    return $conn;
}

/**
 * Preferred PDO connector used by session_history.php
 */
function getPdoConnection(): PDO {
    static $pdo = null;
    if ($pdo instanceof PDO) return $pdo;

    $dsn = sprintf(
        'mysql:host=%s;port=%s;dbname=%s;charset=utf8mb4',
        DB_SERVER,
        DB_PORT,
        DB_NAME
    );

    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,       // throw exceptions
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,             // assoc arrays
        PDO::ATTR_EMULATE_PREPARES   => false,                        // native prepares
    ];

    $pdo = new PDO($dsn, DB_USERNAME, DB_PASSWORD, $options);
    return $pdo;
}
