<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Allow-Headers: Content-Type");

require_once 'config.php';
$conn = getDbConnection();
if (!$conn) { echo json_encode(["status"=>"error","message"=>"Database connection failed"]); exit(); }

$page  = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$limit = isset($_GET['limit']) ? max(1, intval($_GET['limit'])) : 20;
$orgId = isset($_GET['organisation_id']) ? intval($_GET['organisation_id']) : 0;
if ($orgId === 0) { echo json_encode(["status"=>"error","message"=>"Missing organisation_id"]); exit(); }
$offset = ($page - 1) * $limit;

$conds = ["vr.organisation_id = ?"];
$types = "i";
$vals  = [ $orgId ];

if (isset($_GET['house_id']) && $_GET['house_id'] !== '') {
  $conds[] = "vr.house_id = ?";
  $types  .= "i";
  $vals[]  = intval($_GET['house_id']);
}
if (isset($_GET['status']) && $_GET['status'] !== '') {
  $conds[] = "vr.status = ?";
  $types  .= "s";
  $vals[]  = (string)$_GET['status'];
}
if (isset($_GET['id_plates']) && $_GET['id_plates'] !== '') {
  $conds[] = "vr.id_plates = ?";
  $types  .= "s";
  $vals[]  = (string)$_GET['id_plates'];
}
if (isset($_GET['phone_number']) && $_GET['phone_number'] !== '') {
  $conds[] = "vr.phone_number = ?";
  $types  .= "s";
  $vals[]  = (string)$_GET['phone_number'];
}
if (isset($_GET['search']) && $_GET['search'] !== '') {
  $like = "%".(string)$_GET['search']."%";
  $conds[] = "(vr.name LIKE ? OR vr.phone_number LIKE ? OR vr.id_plates LIKE ?)";
  $types  .= "sss";
  $vals[]  = $like; $vals[] = $like; $vals[] = $like;
}

$where = implode(" AND ", $conds);

$sql = "
  SELECT vr.id, vr.house_id, h.house_number, vr.description, vr.name,
         vr.phone_number, vr.image_metadata, vr.id_plates, vr.admitted_by,
         vr.created_at, vr.otp_code, vr.is_exited, vr.status
  FROM visitor_records vr
  LEFT JOIN houses h ON vr.house_id = h.id
  WHERE $where
  ORDER BY vr.created_at DESC
  LIMIT ? OFFSET ?
";
$types .= "ii";
$vals[]  = $limit;
$vals[]  = $offset;

$stmt = $conn->prepare($sql);
if (!$stmt) { echo json_encode(["status"=>"error","message"=>"Failed to prepare statement"]); exit(); }

$bind = [$types];
foreach ($vals as $k => $v) { $bind[] = &$vals[$k]; } // pass by reference
call_user_func_array([$stmt, 'bind_param'], $bind);

$stmt->execute();
$res = $stmt->get_result();
$rows = [];
while ($row = $res->fetch_assoc()) { $rows[] = $row; }
$stmt->close();

echo json_encode([
  "status" => "success",
  "page" => $page,
  "limit" => $limit,
  "total_fetched" => count($rows),
  "visitor_records" => $rows
]);
exit();
