<?php
// config.php

// 0) Timezone (avoid PHP warnings)
date_default_timezone_set('Africa/Nairobi');

// 1) Database configuration
define('DB_CONNECTION', 'mysql');
define('DB_SERVER',     'localhost');
define('DB_USERNAME',   'asbdpijm_shemking');
define('DB_PASSWORD',   'Shemking@18');
define('DB_PORT',       '3306');
define('DB_NAME',       'asbdpijm_guardianprod');
define('SMS_PROVIDER', 'textsms');
define('SMS_BASE', 'https://sms.textsms.co.ke/api/services/');
define('SMS_APIKEY', '41c2aa6e25d87f2e0e26d2a147d21ce5');
define('SMS_PARTNER', '14186');
define('SMS_SHORTCODE', 'Signal VMS');

// 2) Legacy mysqli connection for existing scripts.
//    - Throws exceptions on error.
//    - Enforces UTF‑8.
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
function getDbConnection() {
    $conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME, DB_PORT);
    $conn->set_charset('utf8mb4');
    return $conn;
}

// 3) New PDO connection for JSON‑API scripts.
//    - Persistent connections.
//    - 5‑second timeout to avoid long hangs.
//    - UTF‑8 charset.
//    - Exceptions on errors.
function getPdoConnection() {
    $dsn = sprintf(
        '%s:host=%s;port=%s;dbname=%s;charset=utf8mb4',
        DB_CONNECTION,
        DB_SERVER,
        DB_PORT,
        DB_NAME
    );

    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
        PDO::ATTR_PERSISTENT         => true,
        PDO::ATTR_TIMEOUT            => 5,          // seconds
    ];

    try {
        return new PDO($dsn, DB_USERNAME, DB_PASSWORD, $options);
    } catch (PDOException $e) {
        // Log the real error for debugging
        error_log('PDO connection failed: ' . $e->getMessage());

        // Send a generic JSON error if headers aren’t sent yet
        if (!headers_sent()) {
            http_response_code(500);
            header('Content-Type: application/json; charset=utf-8');
        }
        echo json_encode([
            'success' => false,
            'message' => 'Internal server error'
        ]);
        exit;
    }
}
